<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

class AddNewFieldsToUsersTable extends Migration
{
    public function up()
    {
        Schema::table('users', function (Blueprint $table) {
            // Add new fields in the desired order
            $table->string('phone')->nullable()->after('Email'); // Add phone as a new field
            $table->string('location')->nullable()->after('phone');
            $table->boolean('is_active')->default(true)->after('has_used_trial');
            $table->dateTime('last_login')->nullable()->after('is_active');
        });
    }

    public function down()
    {
        Schema::table('users', function (Blueprint $table) {
            // Revert changes in reverse order
            $table->dropColumn(['last_login', 'is_active', 'location', 'phone']);
        });
    }
}
